/*
 * Decompiled with CFR 0.152.
 */
package DrgPikePkg;

import DrgPikePkg.AbstractCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class NumberCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JTextField textField = new JTextField();
    protected Object oldValue;

    public NumberCellEditor() {
        this.textField.addActionListener(this);
        this.textField.setEditable(true);
        this.textField.setBackground(Color.white);
        this.textField.setHorizontalAlignment(4);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value.toString());
        this.oldValue = value;
        return this.textField;
    }

    public Object getCellEditorValue() {
        String name = this.oldValue.getClass().getName();
        Number returnValue = null;
        try {
            if (name.equals("java.lang.Integer")) {
                returnValue = new Integer(this.textField.getText());
            } else if (name.equals("java.lang.Double")) {
                returnValue = new Double(this.textField.getText());
            } else if (name.equals("java.lang.Float")) {
                returnValue = new Float(this.textField.getText());
            } else if (name.equals("java.lang.Long")) {
                returnValue = new Long(this.textField.getText());
            } else if (name.equals("java.lang.Short")) {
                returnValue = new Short(this.textField.getText());
            } else if (name.equals("java.lang.Byte")) {
                returnValue = new Byte(this.textField.getText());
            } else if (name.equals("java.math.BigDecimal")) {
                returnValue = new BigDecimal(this.textField.getText());
            } else if (name.equals("java.math.BigInteger")) {
                returnValue = new BigInteger(this.textField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return returnValue;
    }
}

