/*
 * Decompiled with CFR 0.152.
 */
package DrgPikePkg;

import DrgPikePkg.DrgFunc;
import DrgPikePkg.DrgPike;
import DrgPikePkg.PikeLDAP;
import DrgPikePkg.RunOpt;
import DrgPikePkg.ZipFiles;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

class PikeFunc
implements Runnable,
RunOpt {
    private DrgPike pc;
    private String[] params;
    private String funcname;
    private String label;
    private String[] errors;
    private String cmd;
    private File flog;
    private String proc_header;
    private String proc_foot_true;
    private String proc_foot_false;
    private ZipFiles zp;
    private boolean unzip;
    private boolean valid;
    private Object output;
    private String batch_id;
    public int ret;
    private boolean canContinueOnError;

    private void $init$() {
        this.pc = null;
        this.params = null;
        this.label = null;
        this.errors = null;
        this.cmd = null;
        this.flog = null;
        this.proc_header = null;
        this.proc_foot_true = null;
        this.proc_foot_false = null;
        this.zp = null;
        this.unzip = false;
        this.valid = true;
        this.output = null;
        this.batch_id = null;
        this.ret = 0;
        this.canContinueOnError = true;
    }

    public String getBatchID() {
        return this.batch_id;
    }

    public void clearErrors() {
        if (this.pc != null) {
            this.pc.clearErrors();
        }
    }

    public Object getOutput() {
        return this.output;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean setValid(boolean valid) {
        this.valid = valid;
        return this.valid;
    }

    public String[] getParams() {
        return this.params;
    }

    public File getTmpFile() {
        return this.flog;
    }

    public String getProcHeader() {
        this.setProcLog();
        return this.proc_header;
    }

    public String getProcFootTrue() {
        this.setProcLog();
        return this.proc_foot_true;
    }

    public String getProcFootFalse() {
        this.setProcLog();
        return this.proc_foot_false;
    }

    private void createTmpFile(String mask) {
        if (mask != null) {
            try {
                this.flog = File.createTempFile(mask + "_", ".log");
                this.flog.delete();
                this.flog.deleteOnExit();
            }
            catch (IOException ioe) {
                this.errors = new String[]{"Nelze vytvo\u0159it soubor pro chybov\u00e1 hl\u00e1\u0161en\u00ed"};
            }
        }
    }

    public void setProcLog() {
        if (this.funcname != null) {
            if (this.funcname.equals("batch_header")) {
                this.proc_header = DrgFunc.makeLogHeader(this.params);
                return;
            }
            if (this.funcname.equals("batch_foot")) {
                this.proc_foot_true = this.proc_foot_false = DrgFunc.makeLogFoot(this.params);
                return;
            }
            if (this.funcname.equals("delete_files")) {
                this.proc_header = null;
                this.proc_foot_false = null;
                this.proc_foot_true = null;
                return;
            }
        }
        this.proc_header = "=====Start:" + this.label + "=====\r\n\r\n";
        this.proc_foot_true = "\r\n=====Usp\u011b\u0161n\u00fd konec:" + this.label + "=====\r\n\r\n";
        this.proc_foot_false = "\r\n=====Chybov\u00fd konec:" + this.label + "=====\r\n\r\n";
    }

    public PikeFunc(String funcname, String[] params, String label) {
        this(funcname, params, label, null);
    }

    public PikeFunc(String funcname, String[] params, String label, String batch_id) {
        this.$init$();
        this.params = params;
        this.funcname = funcname;
        this.label = label;
        this.batch_id = batch_id;
    }

    public PikeFunc(String funcname, String[] params, String label, boolean tmpfile) {
        this(funcname, params, label, tmpfile, null);
    }

    public PikeFunc(String funcname, String[] params, String label, boolean tmpfile, String batch_id) {
        this.$init$();
        this.params = params;
        this.funcname = funcname;
        if (tmpfile) {
            this.createTmpFile(this.funcname);
        }
        this.label = label;
        this.batch_id = batch_id;
    }

    public PikeFunc(String oscommand) {
        this(oscommand, null);
    }

    public PikeFunc(String oscommand, String batch_id) {
        this.$init$();
        this.label = this.cmd = oscommand;
        this.batch_id = batch_id;
    }

    public PikeFunc(String oscommand, String label, String batch_id) {
        this.$init$();
        this.cmd = oscommand;
        this.label = label;
        this.batch_id = batch_id;
    }

    public PikeFunc() {
        this.$init$();
    }

    public PikeFunc(File[] files, String zipfilename, String label, boolean unzip) {
        this(files, zipfilename, label, unzip, null);
    }

    public PikeFunc(File[] files, String zipfilename, String label, boolean unzip, String batch_id) {
        this.$init$();
        this.zp = new ZipFiles(files, zipfilename);
        this.label = label;
        this.unzip = unzip;
        this.batch_id = batch_id;
    }

    public int status() {
        return this.ret;
    }

    public String[] getErrors() {
        try {
            if (this.pc != null && this.pc.getErrors() != null) {
                String[] stringArray = this.pc.getErrors();
                return stringArray;
            }
            if (this.zp != null && this.zp.getErrors() != null) {
                String[] stringArray = this.zp.getErrors();
                return stringArray;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.errors;
    }

    public String getSystemCmd() {
        return this.cmd;
    }

    public String getFuncName() {
        return this.funcname;
    }

    public String getLabel() {
        return this.label;
    }

    public int getStatusProc() {
        if (this.pc != null) {
            return this.pc.getActPct();
        }
        if (this.zp != null) {
            return this.zp.getActPct();
        }
        return 0;
    }

    public String[] getVersion() {
        String[] ret = null;
        this.pc = new DrgPike();
        this.pc.clearErrors();
        ret = this.pc.getVersion();
        this.pc.clearErrors();
        return ret;
    }

    public String[] getSlotId() {
        String[] ret = null;
        this.pc = new DrgPike();
        this.pc.clearErrors();
        ret = this.pc.getSlotIdArr();
        this.pc.clearErrors();
        return ret;
    }

    public int openGlobalLog(String filename) {
        this.pc = new DrgPike();
        this.pc.clearErrors();
        int ret = this.pc.openGLOG(filename);
        this.pc.clearErrors();
        return ret;
    }

    public int closeGlobalLog() {
        this.pc = new DrgPike();
        this.pc.clearErrors();
        int ret = this.pc.closeGLOG();
        this.pc.clearErrors();
        return ret;
    }

    public void run() {
        this.startFunc();
        Thread.currentThread().interrupt();
    }

    public void startFunc() {
        PikeLDAP pl;
        this.ret = -1;
        if (!this.valid) {
            this.ret = 0;
            return;
        }
        if (this.zp != null) {
            this.ret = !this.unzip ? this.zp.zip() : this.zp.unzip();
        }
        if (this.params == null || this.funcname == null) {
            return;
        }
        if (this.funcname.equals("batch_header") || this.funcname.equals("batch_foot") || this.funcname.equals("null")) {
            this.ret = 0;
        }
        if (this.funcname.equals("delete_files")) {
            this.ret = 0;
            int i = 0;
            while (i < this.params.length) {
                File fdel;
                if (this.params[i] == null || !(fdel = new File(this.params[i])).isFile() || !fdel.delete()) {
                    // empty if block
                }
                ++i;
            }
        }
        if (this.funcname.startsWith("test_token") && this.params.length == 11) {
            System.setProperty("TOKEN_USER", "");
            this.pc = new DrgPike();
            this.pc.clearErrors();
            String DN = this.pc.getUserDN(this.params[7], this.params[8], this.params[9]);
            if (DN != null && DN.indexOf(44) > 0) {
                this.params[4] = DN.substring(DN.indexOf(44) + 1).trim();
                this.params[5] = "(" + DN.substring(0, DN.indexOf(44)).trim() + ")";
                PikeLDAP pl2 = new PikeLDAP(this.params[0], Integer.parseInt(this.params[1]), this.params[2], this.params[3], this.params[10]);
                if (pl2.PikeLDAPConnect()) {
                    pl2.setPikeLDAPQuery(this.params[4], this.params[5]);
                    pl2.setPikeLDAPDetailQuery(new String[]{this.params[6]});
                    if (pl2.PikeLDAPExecuteQuery() && pl2.getLDAPValue(this.params[6]) != null) {
                        System.setProperty("TOKEN_USER", pl2.getLDAPValue(this.params[6])[0]);
                    }
                }
                if (this.errors == null) {
                    this.errors = pl2.getErrors();
                }
                pl2.PikeLDAPDisconnect();
            } else {
                this.errors = new String[]{"Na kart\u011b nelze nal\u00e9zt DN certifik\u00e1tu u\u017eivatele"};
            }
            this.pc.clearErrors();
            this.ret = this.errors == null ? 0 : -1;
        }
        if (this.funcname.startsWith("deleteObject") && this.params.length == 3) {
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.deleteObject(this.params[0], this.params[1], this.params[2]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.startsWith("ldap_") && this.params.length == 11 && (pl = new PikeLDAP(this.params[0], Integer.parseInt(this.params[1]), this.params[2], this.params[3], this.params[10])).PikeLDAPConnect()) {
            if (this.params[5] == null && this.funcname.equals("ldap_Data")) {
                this.params[5] = "(cn=" + System.getProperty("TOKEN_USER") + ")";
            }
            pl.setPikeLDAPQuery(this.params[4], this.params[5]);
            pl.setPikeLDAPDetailQuery(new String[]{this.params[6]});
            if (pl.PikeLDAPExecuteQuery() && pl.getLDAPValue(this.params[6]) != null) {
                this.output = pl.getLDAPValue(this.params[6])[0];
                this.pc = new DrgPike();
                this.pc.clearErrors();
                if (this.flog != null) {
                    this.pc.setErrorFile(this.flog.getAbsolutePath());
                }
                String method = "loadBase64" + this.funcname.substring("ldap_".length());
                try {
                    Method m = this.pc.getClass().getDeclaredMethod(method, Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"));
                    if (m != null) {
                        this.ret = Integer.parseInt(m.invoke((Object)this.pc, this.params[7], (String)this.output, this.params[8], this.params[9]).toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.flog != null) {
                    this.pc.closeErrorFile();
                }
            }
            if (this.errors == null) {
                this.errors = pl.getErrors();
            }
            pl.PikeLDAPDisconnect();
        }
        if (this.funcname.equals("recover") && this.params.length == 10) {
            this.setContinueOnError(false);
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.recover(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7], this.params[8], this.params[9]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("desRc") && this.params.length == 8) {
            this.setContinueOnError(false);
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.desRc(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("signFile") && this.params.length == 6) {
            this.setContinueOnError(false);
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.signFile(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("unsignFile") && this.params.length == 6) {
            this.setContinueOnError(false);
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.unsignFile(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("dkontrol") && this.params.length == 9) {
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.dkontrol(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7], this.params[8]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("kkontrol") && this.params.length == 5) {
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.kkontrol(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
        if (this.funcname.equals("drg") && this.params.length == 7) {
            this.pc = new DrgPike();
            this.pc.clearErrors();
            if (this.flog != null) {
                this.pc.setErrorFile(this.flog.getAbsolutePath());
            }
            this.ret = this.pc.drg(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6]);
            if (this.flog != null) {
                this.pc.closeErrorFile();
            }
        }
    }

    private void setContinueOnError(boolean canContinueOnError) {
        this.canContinueOnError = canContinueOnError;
    }

    public boolean continueOnError() {
        return this.canContinueOnError;
    }
}

