/*
 * Decompiled with CFR 0.152.
 */
package DrgPikePkg;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.util.Base64;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class PikeLDAP {
    private String LDAPip;
    private int LDAPport;
    private String LDAPdn;
    private String LDAPpw;
    private LDAPConnection lc;
    private String LDAPSearchBase;
    private String LDAPFilter;
    private LDAPSearchResults LDAPQueryResults;
    private Object[][][] LDAPValues;
    private String[] LDAPDetail;
    private ArrayList errors;
    private boolean debug;
    private String LDAPkeystoreFile;
    private String SSLdebug;

    private void $init$() {
        this.LDAPip = null;
        this.LDAPport = -1;
        this.LDAPdn = null;
        this.LDAPpw = null;
        this.lc = null;
        this.LDAPSearchBase = null;
        this.LDAPFilter = null;
        this.LDAPQueryResults = null;
        this.LDAPValues = null;
        this.LDAPDetail = null;
        this.errors = new ArrayList();
        this.debug = false;
        this.LDAPkeystoreFile = null;
        this.SSLdebug = null;
    }

    public PikeLDAP(String LDAPip, int LDAPport, String LDAPdn, String LDAPpw) {
        this.$init$();
        this.LDAPip = LDAPip;
        this.LDAPport = LDAPport;
        this.LDAPdn = LDAPdn;
        this.LDAPpw = LDAPpw;
    }

    public PikeLDAP(String LDAPip, int LDAPport, String LDAPdn, String LDAPpw, String LDAPkeystoreFile) {
        this.$init$();
        this.LDAPip = LDAPip;
        this.LDAPport = LDAPport;
        this.LDAPkeystoreFile = LDAPkeystoreFile;
        this.LDAPdn = LDAPdn;
        this.LDAPpw = LDAPpw;
    }

    public String[] getErrors() {
        return this.errors.size() > 0 ? this.errors.toArray(new String[this.errors.size()]) : null;
    }

    public Object[][][] getLDAPValues() {
        return this.LDAPValues;
    }

    public Object[][][] getLDAPValues(String attribute) {
        return this.LDAPValues;
    }

    public boolean setPikeLDAPDebug(boolean enabled) {
        this.debug = enabled;
        return this.debug;
    }

    public void setLDAPkeystore(String LDAPkeystoreFile) {
        this.LDAPkeystoreFile = LDAPkeystoreFile;
    }

    public void setLDAPSSLdebug(String SSLdebug) {
        this.SSLdebug = SSLdebug;
    }

    public boolean PikeLDAPConnect() {
        boolean ret = false;
        if (this.LDAPkeystoreFile != null) {
            Security.addProvider((java.security.Provider)new Provider());
            if (this.SSLdebug != null) {
                System.setProperty("javax.net.debug", this.SSLdebug);
            }
            System.setProperty("javax.net.ssl.trustStore", this.LDAPkeystoreFile);
            LDAPJSSESecureSocketFactory ssf = new LDAPJSSESecureSocketFactory();
            LDAPConnection.setSocketFactory((LDAPSocketFactory)ssf);
        }
        this.lc = new LDAPConnection();
        if (this.LDAPdn != null && this.LDAPpw != null) {
            try {
                this.lc.connect(this.LDAPip, this.LDAPport);
                this.lc.bind(3, this.LDAPdn, this.LDAPpw.getBytes("UTF8"));
                ret = true;
            }
            catch (Exception ldape) {
                this.errors.add(ldape.toString());
                ldape.printStackTrace();
            }
        }
        return ret;
    }

    public boolean PikeLDAPDisconnect() {
        try {
            if (this.lc != null) {
                this.lc.disconnect();
                if (this.lc.isTLS()) {
                    this.lc.stopTLS();
                }
                System.getProperties().remove("javax.net.ssl.trustStore");
                System.getProperties().remove("javax.net.debug");
                boolean bl = true;
                return bl;
            }
        }
        catch (LDAPException ldape) {
            this.errors.add(ldape.toString());
            ldape.printStackTrace();
        }
        return false;
    }

    public void setPikeLDAPQuery(String LDAPSearchBase, String LDAPFilter) {
        this.LDAPSearchBase = LDAPSearchBase;
        this.LDAPFilter = LDAPFilter;
    }

    public void setPikeLDAPDetailQuery(String[] LDAPDetail) {
        this.LDAPDetail = LDAPDetail;
    }

    public boolean PikeLDAPExecuteQuery() {
        boolean ret = false;
        if (this.LDAPSearchBase != null && this.LDAPFilter != null && this.lc != null) {
            try {
                this.LDAPQueryResults = this.lc.search(this.LDAPSearchBase, 1, this.LDAPFilter, this.LDAPDetail, false);
                int row = 0;
                int count = 0;
                ret = true;
                LDAPEntry[] nextEntry = null;
                ArrayList<LDAPEntry> al = null;
                while (this.LDAPQueryResults.hasMore()) {
                    if (al == null) {
                        al = new ArrayList<LDAPEntry>();
                    }
                    try {
                        al.add(this.LDAPQueryResults.next());
                        ++count;
                    }
                    catch (LDAPException e) {
                        this.errors.add(e.toString());
                        if (this.debug) {
                            System.out.println("Error: " + e.toString());
                        }
                        e.printStackTrace();
                        ret = false;
                    }
                }
                if (al != null) {
                    nextEntry = al.toArray(new LDAPEntry[al.size()]);
                }
                int k = 0;
                while (nextEntry != null && k < nextEntry.length) {
                    if (this.debug) {
                        System.out.println("\n" + nextEntry[k].getDN());
                        System.out.println("  Attributes: ");
                    }
                    LDAPAttributeSet attributeSet = nextEntry[k].getAttributeSet();
                    Iterator allAttributes = attributeSet.iterator();
                    if (this.debug) {
                        System.out.println("Pocet atributu:" + (attributeSet.size() + 1));
                    }
                    if (this.LDAPValues == null) {
                        this.LDAPValues = new Object[count][attributeSet.size() + 1][2];
                    }
                    int row_in_row = 0;
                    if (this.debug) {
                        System.out.println(count + ":" + row);
                    }
                    this.LDAPValues[row][row_in_row][0] = "dn";
                    this.LDAPValues[row][row_in_row][1] = nextEntry[k].getDN();
                    ++row_in_row;
                    while (allAttributes.hasNext()) {
                        Enumeration allValues;
                        LDAPAttribute attribute = (LDAPAttribute)allAttributes.next();
                        String attributeName = attribute.getName();
                        if (this.debug) {
                            System.out.println("    " + attributeName);
                        }
                        if ((allValues = attribute.getByteValues()) != null) {
                            if (this.debug) {
                                System.out.println("Pocet hodnot atributu:" + attribute.size());
                            }
                            while (allValues.hasMoreElements()) {
                                byte[] Value = (byte[])allValues.nextElement();
                                String SValue = null;
                                if (Base64.isLDIFSafe((byte[])Value)) {
                                    SValue = new String(Value);
                                    if (this.debug) {
                                        System.out.println("    S  " + SValue);
                                    }
                                } else {
                                    SValue = Base64.encode((byte[])Value);
                                    if (this.debug) {
                                        System.out.println("    B  " + SValue);
                                    }
                                }
                                this.LDAPValues[row][row_in_row][0] = attributeName;
                                this.LDAPValues[row][row_in_row][1] = SValue;
                            }
                        }
                        ++row_in_row;
                    }
                    ++row;
                    ++k;
                }
            }
            catch (LDAPException ldape) {
                ret = false;
                this.errors.add(ldape.toString());
                ldape.printStackTrace();
            }
        }
        return ret;
    }

    public LDAPConnection getPikeLDAPConnection() {
        return this.lc;
    }

    public String[] getLDAPValue(String attribute) {
        String[] ret = null;
        if (this.LDAPValues != null) {
            ArrayList<Object> al = null;
            int i = 0;
            while (i < this.LDAPValues.length) {
                int j = 0;
                while (j < this.LDAPValues[i].length) {
                    if (this.LDAPValues[i][j][0] != null && this.LDAPValues[i][j][0].equals(attribute)) {
                        if (al == null) {
                            al = new ArrayList<Object>();
                        }
                        al.add(this.LDAPValues[i][j][1]);
                    }
                    ++j;
                }
                ++i;
            }
            if (al != null) {
                ret = al.toArray(new String[al.size()]);
            }
        } else {
            this.errors.add("LDAP: pro dotaz '" + this.LDAPSearchBase + "' a detail '" + this.LDAPFilter + "'\r\n");
            this.errors.add("LDAP: nelze naj\u00edt hodnotu pro atribut '" + attribute + "'");
        }
        return ret;
    }

    public static void main(String[] args) {
        PikeLDAP pl = new PikeLDAP("127.0.0.1", 636, "cn=LDAP manager,ou=nrc,o=ipvz,c=cz", "secret");
        pl.setLDAPkeystore("/home/hans/ldapclient.keystore");
        if (pl.PikeLDAPConnect()) {
            pl.setPikeLDAPQuery("ou=osoby,ou=nrc,o=ipvz,c=cz", "(cn=Jan Handl)");
            pl.setPikeLDAPDetailQuery(new String[]{"cn"});
            pl.PikeLDAPExecuteQuery();
            System.out.println(pl.getLDAPValue("cn")[0]);
            pl.PikeLDAPDisconnect();
        }
    }
}

