/*
 * Decompiled with CFR 0.152.
 */
package DrgPikePkg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

class ZipFiles {
    private File[] files;
    private String filename;
    private String[] errors;
    private int procent;

    private void $init$() {
        this.files = null;
        this.filename = null;
        this.errors = null;
        this.procent = 0;
    }

    public ZipFiles(File[] files, String filename) {
        this.$init$();
        this.files = files;
        this.filename = filename;
    }

    public int getActPct() {
        return this.procent;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public int unzip() {
        int ret = -1;
        if (this.files == null) {
            this.errors = new String[]{"CHYBA: p\u0159i inicializaci unzipu"};
            return ret;
        }
        int i = 0;
        while (i < this.files.length) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(this.files[i]);
            }
            catch (IOException ioezip1) {
                this.errors = new String[]{"CHYBA: p\u0159i otev\u0159en\u00ed zip souboru " + this.files[i]};
                int n = ret;
                return n;
            }
            Enumeration<? extends ZipEntry> e = zf.entries();
            ZipEntry ze = null;
            while (e.hasMoreElements()) {
                InputStream iszf = null;
                ze = e.nextElement();
                if (ze.isDirectory()) {
                    new File(ze.getName()).mkdirs();
                    continue;
                }
                try {
                    iszf = zf.getInputStream(ze);
                }
                catch (IOException ioezip1) {
                    this.errors = new String[]{"CHYBA: p\u0159i \u010dten\u00ed entry zip souboru"};
                    int n = ret;
                    return n;
                }
                File fout = null;
                fout = this.filename != null ? new File(this.filename) : new File(ze.getName());
                try {
                    if (!fout.exists()) {
                        fout.createNewFile();
                    } else if (fout.isDirectory()) {
                        fout = new File(fout, ze.getName());
                    }
                }
                catch (IOException ioe) {
                    this.errors = new String[]{"CHYBA: Nelze vytvo\u0159it v\u00fdstupn\u00ed soubor pro dekompresi"};
                    try {
                        iszf.close();
                        zf.close();
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    int n = ret;
                    return n;
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(fout);
                }
                catch (FileNotFoundException fne) {
                    this.errors = new String[]{"CHYBA: Neexistuje v\u00fdstupn\u00ed soubor"};
                    try {
                        iszf.close();
                        zf.close();
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    int n = ret;
                    return n;
                }
                byte[] buff = new byte[4096];
                try {
                    int len;
                    int precteno = 0;
                    this.procent = 0;
                    while ((len = iszf.read(buff)) > 0) {
                        Thread.currentThread();
                        if (Thread.interrupted()) {
                            try {
                                iszf.close();
                                zf.close();
                            }
                            catch (IOException ioex) {
                                // empty catch block
                            }
                            int n = ret;
                            return n;
                        }
                        this.procent = (precteno += len) != 0 && ze.getSize() != 0L ? (int)((long)(100 * precteno) / ze.getSize()) : 0;
                        out.write(buff, 0, len);
                    }
                    out.close();
                    iszf.close();
                }
                catch (IOException ioe) {
                    this.errors = new String[]{"CHYBA: Nelze zpracovat zip soubor"};
                    try {
                        out.close();
                        iszf.close();
                        zf.close();
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    int n = ret;
                    return n;
                }
            }
            ret = 0;
            try {
                zf.close();
            }
            catch (IOException ioe) {
                this.errors = new String[]{"CHYBA: Nelze uzavrit zip soubor"};
            }
            ++i;
        }
        return ret;
    }

    public int zip() {
        int ret = -1;
        if (this.files == null || this.filename == null) {
            return ret;
        }
        byte[] buff = new byte[4096];
        try {
            FileOutputStream fout = new FileOutputStream(this.filename);
            ZipOutputStream out = new ZipOutputStream(fout);
            int i = 0;
            while (i < this.files.length) {
                int len;
                FileInputStream in = new FileInputStream(this.files[i].getAbsolutePath());
                out.putNextEntry(new ZipEntry(this.files[i].getName()));
                int precteno = 0;
                this.procent = 0;
                while ((len = in.read(buff)) > 0) {
                    Thread.currentThread();
                    if (Thread.interrupted()) {
                        fout.close();
                        out.closeEntry();
                        out.close();
                        in.close();
                        int n = ret;
                        return n;
                    }
                    this.procent = this.files[i].length() != 0L && precteno != 0 ? (int)((long)(100 * (precteno += len)) / this.files[i].length()) : 0;
                    out.write(buff, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
            fout.close();
            ret = 0;
        }
        catch (IOException e) {
            this.errors = new String[]{"CHYBA: p\u0159i komprimaci souboru"};
        }
        return ret;
    }
}

